%% LaTeX2e class file for for Santa Fe Institute
%% Copyrighted by the Santa Fe Institute and may
%% not be used without our permission.
%%
%% Created by Integre Technical Publishing Co., Inc., for the
%% Santa Fe Institute.
%%
%% Modeled after book.cls of the standard LaTeX2e distribution.
%%
\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{sfibook}
              [1998/18/06 v0.9
 SFI Book LaTeX document class]
\newif\if@restonecol
\newif\if@titlepage
\@titlepagetrue
\newif\if@openright
\newif\if@mainmatter \@mainmattertrue
\if@compatibility\else
\DeclareOption{a4paper}
   {\setlength\paperheight {297mm}%
    \setlength\paperwidth  {210mm}}
\DeclareOption{a5paper}
   {\setlength\paperheight {210mm}%
    \setlength\paperwidth  {148mm}}
\DeclareOption{b5paper}
   {\setlength\paperheight {250mm}%
    \setlength\paperwidth  {176mm}}
\DeclareOption{letterpaper}
   {\setlength\paperheight {11in}%
    \setlength\paperwidth  {8.5in}}
\DeclareOption{legalpaper}
   {\setlength\paperheight {14in}%
    \setlength\paperwidth  {8.5in}}
\DeclareOption{executivepaper}
   {\setlength\paperheight {10.5in}%
    \setlength\paperwidth  {7.25in}}
\DeclareOption{landscape}
   {\setlength\@tempdima   {\paperheight}%
    \setlength\paperheight {\paperwidth}%
    \setlength\paperwidth  {\@tempdima}}
\fi
\if@compatibility\else
\DeclareOption{oneside}{\@twosidefalse \@mparswitchfalse}
\fi
\DeclareOption{twoside}{\@twosidetrue  \@mparswitchtrue}
\DeclareOption{draft}{\setlength\overfullrule{5pt}}
\if@compatibility\else
\DeclareOption{final}{\setlength\overfullrule{0pt}}
\fi
\DeclareOption{titlepage}{\@titlepagetrue}
\if@compatibility\else
\DeclareOption{notitlepage}{\@titlepagefalse}
\fi
\if@compatibility
\@openrighttrue
\else
\DeclareOption{openright}{\@openrighttrue}
\DeclareOption{openany}{\@openrightfalse}
\fi
\if@compatibility\else
\DeclareOption{onecolumn}{\@twocolumnfalse}
\fi
\DeclareOption{twocolumn}{\@twocolumntrue}
\DeclareOption{leqno}{\input{leqno.clo}}
\DeclareOption{fleqn}{\input{fleqn.clo}}
\newif\if@contrib
\DeclareOption{contrib}{\@contribtrue}
\DeclareOption{openbib}{%
  \AtEndOfPackage{%
   \renewcommand\@openbib@code{%
      \advance\leftmargin\bibindent
      \itemindent -\bibindent
      \listparindent \itemindent
      \parsep \z@
      }%
   \renewcommand\newblock{\par}}%
}
%
\newif\ifbibundeclared	\global\bibundeclaredtrue
\DeclareOption{chapnumbib}{\global\bibundeclaredfalse
  \AtEndOfPackage{%
\global\let\thebibliography\thechapnumbibliography
	\global\let\endthebibliography\endthechapnumbibliography\relax}}
\DeclareOption{secnumbib}{\global\bibundeclaredfalse
	  \AtEndOfPackage{%
\global\let\thebibliography\thesecnumbibliography
	\global\let\endthebibliography\endthesecnumbibliography\relax}}
\DeclareOption{chapnonumbib}{\global\bibundeclaredfalse
	  \AtEndOfPackage{%
\global\let\thebibliography\thechapnonumbibliography
	\global\let\endthebibliography\endthechapnonumbibliography\relax}}
\DeclareOption{secnonumbib}{\global\bibundeclaredfalse
	  \AtEndOfPackage{%
\global\let\thebibliography\thesecnonumbibliography
	\global\let\endthebibliography\endthesecnonumbibliography\relax}}
%
\ExecuteOptions{letterpaper,twoside,onecolumn,final,openright}
\ProcessOptions

\input{sfi10.clo}
\setlength\lineskip{1\p@}
\setlength\normallineskip{1\p@}
\renewcommand\baselinestretch{}
\setlength\parskip{0\p@}
\@lowpenalty   51
\@medpenalty  151
\@highpenalty 301
\setcounter{topnumber}{2}
\renewcommand\topfraction{.8}
\setcounter{bottomnumber}{1}
\renewcommand\bottomfraction{.8}
\setcounter{totalnumber}{3}
\renewcommand\textfraction{.2}
\renewcommand\floatpagefraction{.8}
\setcounter{dbltopnumber}{2}
\renewcommand\dbltopfraction{.8}
\renewcommand\dblfloatpagefraction{.5}
\def\ps@plain{\let\@mkboth\@gobbletwo
     \let\@oddhead\@empty\def\@oddfoot{\reset@font\hfill
			\large\sffamily\textbf\thepage}\let\@evenhead\@empty

	\def\@evenfoot{\reset@font\large\sffamily\textbf\thepage\hfill}}
\if@twoside
  \def\ps@headings{%
      \let\@oddfoot\@empty\let\@evenfoot\@empty
      \def\@evenhead{\large\sffamily\textbf{\thepage}\kern3pc
			\small\sffamily\leftmark\hfill}%
      \def\@oddhead{\hfil{\small\sffamily\rightmark}\kern3pc\large
			\sffamily\textbf{\thepage}}%
      \let\@mkboth\markboth
	\def\titlemark##1{\markboth{##1}{##1}}%
    \def\chaptermark##1{%
      \markright {\ifnum \c@secnumdepth >\m@ne
          \if@mainmatter
            \@chapapp\ \thechapter
			\else
			##1\fi
			\else##1\fi}}%
    \def\sectionmark##1{}}
\else
  \def\ps@headings{%
    \let\@oddfoot\@empty
    \def\@oddhead{{\slshape\rightmark}\hfil\thepage}%
    \let\@mkboth\markboth
    \def\chaptermark##1{%
      \markright {\MakeUppercase{%
        \ifnum \c@secnumdepth >\m@ne
          \if@mainmatter
            \@chapapp\ \thechapter. \ %
          \fi
        \fi
        ##1}}}}
\fi
\def\ps@myheadings{%
        \def\@oddfoot{%
           \reset@font\hfill
         \begin{tabular}{rr}
         \normalfont\subsecsize\sffamily\bfseries\small{Collective
		 Cognition---Mathematical Foundations of
		 Distributed Intelligence}\\
         \normalfont\subsecsize\sffamily\bfseries\small{edited by J. P.
		 Crutchfield, C. R. Shalizi, K. Tumer, and D. H.  Wolpert}
		 &\hbox to .375truein{%
		     	\hfil\large\sffamily\textbf\thepage}
        \end{tabular}}
        \let\@evenfoot\@empty
        \def\@evenhead{}%
        \def\@oddhead{}%
        \let\@mkboth\@gobbletwo
        \let\chaptermark\@gobble
        \let\sectionmark\@gobble
    }
\if@titlepage
\newcommand\maketitle{\begin{titlepage}%
  \let\footnotesize\small
  \let\footnoterule\relax
  \let \footnote \thanks
  \null\vfil
  \vskip 60\p@
  \begin{center}%
    {\LARGE \@title \par}%
    \vskip 3em%
    {\large
     \lineskip .75em%
      \begin{tabular}[t]{c}%
        \@author
      \end{tabular}\par}%
      \vskip 1.5em%
    {\large \@date \par}%       % Set date in \large size.
  \end{center}\par
  \@thanks
  \vfil\null
  \end{titlepage}%
  \setcounter{footnote}{0}%
  \global\let\thanks\relax
  \global\let\maketitle\relax
  \global\let\@thanks\@empty
%  \global\let\@author\@empty
  \global\let\@date\@empty
  \global\let\@title\@empty
  \global\let\title\relax
  \global\let\author\relax
  \global\let\date\relax
  \global\let\and\relax
}
\else
\newcommand\maketitle{\par
  \begingroup
    \renewcommand\thefootnote{\@fnsymbol\c@footnote}%
    \def\@makefnmark{\rlap{\@textsuperscript{\normalfont\@thefnmark}}}%
    \long\def\@makefntext##1{\parindent 1em\noindent
            \hb@xt@1.8em{%
                \hss\@textsuperscript{\normalfont\@thefnmark}}##1}%
    \if@twocolumn
      \ifnum \col@number=\@ne
        \@maketitle
      \else
        \twocolumn[\@maketitle]%
      \fi
    \else
      \newpage
      \global\@topnum\z@   % Prevents figures from going at top of page.
      \@maketitle
    \fi
    \thispagestyle{plain}\@thanks
  \endgroup
  \setcounter{footnote}{0}%
  \global\let\thanks\relax
  \global\let\maketitle\relax
  \global\let\@maketitle\relax
  \global\let\@thanks\@empty
%  \global\let\@author\@empty
  \global\let\@date\@empty
  \global\let\@title\@empty
  \global\let\title\relax
  \global\let\author\relax
  \global\let\date\relax
  \global\let\and\relax
}
\def\@maketitle{%
  \newpage
  \null
  \vskip 2em%
  \begin{center}%
  \let \footnote \thanks
    {\LARGE \@title \par}%
    \vskip 1.5em%
    {\large
      \lineskip .5em%
      \begin{tabular}[t]{c}%
        \@author
      \end{tabular}\par}%
    \vskip 1em%
    {\large \@date}%
  \end{center}%
  \par
  \vskip 1.5em}
\fi
\def\author#1{%
	\if@contrib\markboth{#1}{#1}
	\addcontentsline{toc}{author}{#1}
  \newcommand\@author{\theauthor}
%		\vskip-235pt\vbox to 235pt{
%		\bgroup\parindent0pt\large\sffamily\raggedright#1\par\egroup}
  \fi}
\newcommand\titlemark[1]{}
\newcommand*\chaptermark[1]{}
\setcounter{secnumdepth}{3}
\newcounter {part}
\newcounter {chapter}
\newcounter {section}[chapter]
\newcounter {subsection}[section]
\newcounter {subsubsection}[subsection]
\newcounter {paragraph}[subsubsection]
\newcounter {subparagraph}[paragraph]
\renewcommand \thepart {\@Roman\c@part}
%\renewcommand \thechapter {\@arabic\c@chapter}
\renewcommand \thesection {\@arabic\c@section}
\renewcommand\thesubsection   {\thesection.\@arabic\c@subsection}
\renewcommand\thesubsubsection{\thesubsection .\@arabic\c@subsubsection}
\renewcommand\theparagraph    {\thesubsubsection.\@arabic\c@paragraph}
\renewcommand\thesubparagraph {\theparagraph.\@arabic\c@subparagraph}
\newcommand\@chapapp{\chaptername}
\newcommand\frontmatter{%
  \if@openright
    \cleardoublepage
  \else
    \clearpage
  \fi
  \@mainmatterfalse
  \pagenumbering{roman}}
\newcommand\mainmatter{%
  \if@openright
    \cleardoublepage
  \else
    \clearpage
  \fi
  \@mainmattertrue
  \pagenumbering{arabic}}
\newcommand\backmatter{%
  \if@openright
    \cleardoublepage
  \else
    \clearpage
  \fi
  \@mainmatterfalse}
\newcommand\part{%
  \if@openright
    \cleardoublepage
  \else
    \clearpage
  \fi
  \thispagestyle{plain}%
  \if@twocolumn
    \onecolumn
    \@tempswatrue
  \else
    \@tempswafalse
  \fi
  \null\vfil
  \secdef\@part\@spart}

\def\@part[#1]#2{%
    \ifnum \c@secnumdepth >-2\relax
      \refstepcounter{part}%
      \addcontentsline{toc}{part}{\thepart\hspace{1em}#1}%
    \else
      \addcontentsline{toc}{part}{#1}%
    \fi
    \markboth{}{}%
    {\centering
     \interlinepenalty \@M
     \normalfont
     \ifnum \c@secnumdepth >-2\relax
       \huge\bfseries \partname~\thepart
       \par
       \vskip 20\p@
     \fi
     \Huge \bfseries #2\par}%
    \@endpart}
\def\@spart#1{%
    {\centering
     \interlinepenalty \@M
     \normalfont
     \Huge \bfseries #1\par}%
    \@endpart}
\def\@endpart{\vfil\newpage
              \if@twoside
                \null
                \thispagestyle{empty}%
                \newpage
              \fi
              \if@tempswa
                \twocolumn
              \fi}
\newcommand\chapter{\if@openright\cleardoublepage\else\clearpage\fi
                    \thispagestyle{myheadings}%
    \global\@topnum\z@
                    \@afterindentfalse
					\secdef\@chapter\@schapter
     }


\def\@chapter[#1]#2#3{\ifnum \c@secnumdepth >\m@ne
                       \if@mainmatter
                         \if@contrib\else
						\refstepcounter{chapter}%
                         \typeout{\@chapapp\space\thechapter.}%
						\fi
                         \addcontentsline{toc}{chapter}%
                                   {\if@contrib\else
	\protect\numberline{\MakeUppercase\chaptername\ \thechapter}\fi#1}%
                       \else
                         \addcontentsline{toc}{chapter}{#1}%
                       \fi
                    \else
                      \addcontentsline{toc}{chapter}{#1}%
                    \fi
                    \chaptermark{#1}%
                    \addtocontents{lof}{\protect\addvspace{10\p@}}%
                    \addtocontents{lot}{\protect\addvspace{10\p@}}%
                    \if@twocolumn
                      \@topnewpage[\@makeschapterhead{#2}{#3}]%
                    \else
                      \@makeschapterhead{#2}{#3}%
                      \@afterheading
                    \fi}
%\def\@makeschapterhead#1#2{%
%  \vspace*{-15\p@}%
%  {\parindent \z@ \raggedright \TITLESIZE\sffamily
%	\noindent\vphantom{LECTURE}%
%			\vrule height1pt depth0pt width\textwidth
 %       \par\nobreak
%        \vskip .7\p@
%    \interlinepenalty\@M
%    \MakeUppercase{#1}\strut
%	\vskip1pt
%	\hrule height1pt
%	\par\nobreak
%    \vskip 240\p@ plus 24\p@ minus 24\p@
%  }}

\def\@makeschapterhead#1#2{%
   {\parindent \z@ \relax\par
   \vbox to 4truein{%
    \raggedright\TITLESIZE\sffamily
   \noindent\vphantom{LECTURE}%
   \par\nobreak
   \vskip .7\p@
   \interlinepenalty\@M
   {#1}\strut
   \vskip1pt
%   \hrule height1pt
   \par\nobreak
   \vskip 18\p@
   \normalfont\large\sffamily\bfseries{#2}\vfill}
   }}

\def\@schapter#1{\if@twocolumn
                   \@topnewpage[\@makeschapterhead{#1}]%
                 \else
                   \@makeschapterhead{#1}%
                   \@afterheading
                 \fi}
%\def\@makeschapterhead#1{%
%  \vspace*{-15\p@}%
%  {\parindent \z@ \raggedright \TITLESIZE\sffamily
%	\noindent\vphantom{LECTURE}%
%%			\vrule height1pt depth0pt width\textwidth
%        \par\nobreak
%        \vskip .7\p@
%    \interlinepenalty\@M
%    #1\strut
%	\vskip1pt
%	\hrule height1pt
%	\par\nobreak
%    \vskip 240\p@ plus 24\p@ minus 24\p@
%  }}

\def\@makeschapterhead#1#2{%
   {\parindent \z@ \relax\par
   \vbox to 4truein{%
    \raggedright\TITLESIZE\sffamily
   \noindent\vphantom{LECTURE}%
   \par\nobreak
   \vskip .7\p@
   \interlinepenalty\@M
   {#1}\strut
   \vskip1pt
%   \hrule height1pt
   \par\nobreak
   \vskip 18\p@
   \normalfont\large\sffamily\bfseries{#2}\vfill}
   }}

\newcommand\section{\@startsection {section}{1}{\z@}%
                                   {-24\p@\@plus-6\p@ \@minus -6\p@}%
                                   {12\p@}%
{\normalfont\large\sffamily\bfseries\raggedright\MakeUppercase}}
\newcommand\subsection{\@startsection{subsection}{2}{\z@}%
                                   {-18\p@\@plus -4\p@ \@minus -4\p@}%
                                   {6\p@}%
{\normalfont\subsecsize\sffamily\bfseries\raggedright\MakeUppercase}}
\newcommand\subsubsection{\@startsection{subsubsection}{3}{\z@}%
                                   {-12\p@\@plus -2\p@ \@minus -2\p@}%
                                   {-1em}%
                                   {\normalfont\small\sffamily}}
\newcommand\paragraph{\@startsection{paragraph}{4}{\z@}%
                                   {-12\p@\@plus -2\p@ \@minus -2\p@}%
                                   {-1em}%
                                   {\normalfont\normalsize}}
\let\subsubsubsection=\paragraph
\newcommand\subparagraph{\@startsection{subparagraph}{5}{\parindent}%
                                   {3.25ex \@plus1ex \@minus .2ex}%
                                   {-1em}%
                                   {\normalfont\normalsize\bfseries}}
\if@twocolumn
  \setlength\leftmargini  {1em}
\else
  \setlength\leftmargini  {1.5em}
\fi
\leftmargin  \leftmargini
\setlength\leftmarginii  {3em}
\setlength\leftmarginiii {1.87em}
\setlength\leftmarginiv  {1.7em}
\if@twocolumn
  \setlength\leftmarginv  {.5em}
  \setlength\leftmarginvi {.5em}
\else
  \setlength\leftmarginv  {1em}
  \setlength\leftmarginvi {1em}
\fi
\setlength  \labelsep  {.5em}
\setlength  \labelwidth{\leftmargini}
\addtolength\labelwidth{-\labelsep}
\@beginparpenalty -\@lowpenalty
\@endparpenalty   -\@lowpenalty
\@itempenalty     -\@lowpenalty
\renewcommand\theenumi{\@arabic\c@enumi}
\renewcommand\theenumii{\@alph\c@enumii}
\renewcommand\theenumiii{\@roman\c@enumiii}
\renewcommand\theenumiv{\@Alph\c@enumiv}
\newcommand\labelenumi{\theenumi.}
\newcommand\labelenumii{(\theenumii)}
\newcommand\labelenumiii{\theenumiii.}
\newcommand\labelenumiv{\theenumiv.}
\renewcommand\p@enumii{\theenumi}
\renewcommand\p@enumiii{\theenumi(\theenumii)}
\renewcommand\p@enumiv{\p@enumiii\theenumiii}
\newcommand\labelitemi{\textbullet}
\newcommand\labelitemii{\normalfont\bfseries \textendash}
\newcommand\labelitemiii{\textasteriskcentered}
\newcommand\labelitemiv{\textperiodcentered}
\newenvironment{description}
               {\list{}{\labelwidth\z@ \itemindent-\leftmargin
                        \let\makelabel\descriptionlabel}}
               {\endlist}
\newcommand*\descriptionlabel[1]{\hspace\labelsep
                                \normalfont\bfseries #1}
\newenvironment{verse}
               {\let\\\@centercr
                \list{}{\itemsep      \z@
                        \itemindent   -1.5em%
                        \listparindent\itemindent
                        \rightmargin  \leftmargin
                        \advance\leftmargin 1.5em}%
                \item\relax}
               {\endlist}
\newenvironment{quotation}
               {\list{}{\leftmargin18pt
						\listparindent 1.5em%
                        \itemindent    \listparindent
                        \rightmargin   \leftmargin
                        \parsep        \z@ \@plus\p@}%
                \item\relax}
               {\endlist}
\newenvironment{quote}
               {\list{}{\leftmargin18pt
					\rightmargin\leftmargin}%
                \item\relax}
               {\endlist}
\newenvironment{abstract}
               {\list{}{\leftmargin18pt
					\rightmargin\leftmargin
		\listparindent\parindent}%
                \item\relax}
               {\endlist}
\if@compatibility
\newenvironment{titlepage}
    {%
      \cleardoublepage
      \if@twocolumn
        \@restonecoltrue\onecolumn
      \else
        \@restonecolfalse\newpage
      \fi
      \thispagestyle{empty}%
      \setcounter{page}\z@
    }%
    {\if@restonecol\twocolumn \else \newpage \fi
    }
\else
\newenvironment{titlepage}
    {%
      \cleardoublepage
      \if@twocolumn
        \@restonecoltrue\onecolumn
      \else
        \@restonecolfalse\newpage
      \fi
      \thispagestyle{empty}%
      \setcounter{page}\@ne
    }%
    {\if@restonecol\twocolumn \else \newpage \fi
     \if@twoside\else
        \setcounter{page}\@ne
     \fi
    }
\fi
\newcommand\appendix{\par
  \setcounter{chapter}{0}%
  \setcounter{section}{0}%
  \renewcommand\@chapapp{\appendixname}%
  \renewcommand\thechapter{\@Alph\c@chapter}}
\setlength\arraycolsep{5\p@}
\setlength\tabcolsep{6\p@}
\setlength\arrayrulewidth{.4\p@}
\setlength\doublerulesep{2\p@}
\setlength\tabbingsep{\labelsep}
\skip\@mpfootins = \skip\footins
\setlength\fboxsep{3\p@}
\setlength\fboxrule{.4\p@}
\@addtoreset {equation}{chapter}
\renewcommand\theequation
  {\ifnum \c@chapter>\z@ \thechapter.\fi
   \@arabic\c@equation}
\newcounter{figure}[chapter]
%\if@contrib
\renewcommand \thefigure
     {%\ifnum \c@chapter>\z@ \thechapter.\fi
      \@arabic\c@figure}
%\else
%\renewcommand \thefigure
%     {\@arabic\c@figure}
%\fi
\def\fps@figure{tbp}
\def\ftype@figure{1}
\def\ext@figure{lof}
\def\fnum@figure{\figurename~\thefigure}
\newenvironment{figure}
               {\@float{figure}}
               {\end@float}
\newenvironment{figure*}
               {\@dblfloat{figure}}
               {\end@dblfloat}
\newcounter{table}[chapter]
\renewcommand \thetable
     {\ifnum \c@chapter>\z@ \thechapter.\fi \@arabic\c@table}
\def\fps@table{tbp}
\def\ftype@table{2}
\def\ext@table{lot}
\def\fnum@table{\tablename~\thetable}
%%%changed here 11-24-98
\newenvironment{table}
               {\@float{table}
 \long\def\@makefntext##1{\parindent 1em\noindent
            \hb@xt@1.2em{%
                \hss\@textsuperscript{\normalfont\@thefnmark}}##1}%
                \small}
               {\end@float}
\newenvironment{table*}
               {\@dblfloat{table}\small}
               {\end@dblfloat}
\newlength\abovecaptionskip
\newlength\belowcaptionskip
\setlength\abovecaptionskip{0\p@}
\setlength\belowcaptionskip{4\p@}
\long\def\@makecaption#1#2{%
  \vskip\abovecaptionskip\small
    {\sffamily#1}\quad #2\par
  \vskip\belowcaptionskip}
\DeclareOldFontCommand{\rm}{\normalfont\rmfamily}{\mathrm}
\DeclareOldFontCommand{\sf}{\normalfont\sffamily}{\mathsf}
\DeclareOldFontCommand{\tt}{\normalfont\ttfamily}{\mathtt}
\DeclareOldFontCommand{\bf}{\normalfont\bfseries}{\mathbf}
\DeclareOldFontCommand{\it}{\normalfont\itshape}{\mathit}
\DeclareOldFontCommand{\sl}{\normalfont\slshape}{\@nomath\sl}
\DeclareOldFontCommand{\sc}{\normalfont\scshape}{\@nomath\sc}
\DeclareRobustCommand*\cal{\@fontswitch\relax\mathcal}
\DeclareRobustCommand*\mit{\@fontswitch\relax\mathnormal}
\newcommand\@pnumwidth{2pc}
\newcommand\@tocrmarg{0\p@} %{2.55em}
\newcommand\@dotsep{4.5}
\setcounter{tocdepth}{0}
\newcommand\tableofcontents{%
    \if@twocolumn
      \@restonecoltrue\onecolumn
    \else
      \@restonecolfalse
    \fi
    \chapter*{\contentsname
        \@mkboth{%
           \contentsname}{\contentsname}}%
    \@starttoc{toc}%
    \if@restonecol\twocolumn\fi
    }
\renewcommand\tableofcontents{\begingroup
  \makeatletter
  \if@filesw \expandafter\newwrite\csname tf@toc\endcsname
             \expandafter\openout \csname tf@toc\endcsname \jobname.toc\relax
  \fi \global\@nobreakfalse \endgroup}


\newcommand*\l@part[2]{%
  \ifnum \c@tocdepth >-2\relax
    \addpenalty{-\@highpenalty}%
    \addvspace{2.25em \@plus\p@}%
    \begingroup
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      {\leavevmode
       \large \bfseries #1\hfil \hb@xt@\@pnumwidth{\hss #2}}\par
       \nobreak
         \global\@nobreaktrue
         \everypar{\global\@nobreakfalse\everypar{}}%
    \endgroup
  \fi}
\newcommand*\l@chapter[2]{%
  \ifnum \c@tocdepth >\m@ne
    \addpenalty{-\@highpenalty}%
    \vskip 1.0em \@plus\p@
    \setlength\@tempdima{1.5em}%
    \begingroup
	\def\numberline##1{##1:\newline}%
      \parindent \z@ \raggedright
		\advance\rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      \leavevmode \bfseries
      %\advance\leftskip\@tempdima
      %\hskip -\leftskip
\if@contrib
      #1\par
\else
      #1\nobreak\hfill \nobreak\hb@xt@\@pnumwidth{\hss\textsf{#2}}\par
\fi
      \penalty\@highpenalty
    \endgroup
  \fi}
\newcommand*\l@author[2]{\if@contrib
  \ifnum \c@tocdepth >\m@ne
    \addpenalty{-\@highpenalty}%
    \vskip 0\p@
    \setlength\@tempdima{1.5em}%
    \begingroup
      \parindent \z@ \raggedright
		\advance\rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      \leavevmode \bfseries
      \advance\leftskip2pc %\@tempdima
      {\itshape#1}\nobreak\hfill \nobreak
		\hb@xt@\@pnumwidth{\hss\textsf{#2}}\par
      \penalty\@highpenalty
    \endgroup
  \fi\else\fi}
\newcommand*\l@section{\@dottedtocline{1}{1.5em}{2.3em}}
	\renewcommand*\l@section[2]{}
\newcommand*\l@subsection{\@dottedtocline{2}{3.8em}{3.2em}}
	\renewcommand*\l@subsection[2]{}
\newcommand*\l@subsubsection{\@dottedtocline{3}{7.0em}{4.1em}}
	\renewcommand*\l@subsubsection[2]{}
\newcommand*\l@paragraph{\@dottedtocline{4}{10em}{5em}}
	\renewcommand*\l@paragraph[2]{}
\newcommand*\l@subparagraph{\@dottedtocline{5}{12em}{6em}}
	\renewcommand*\l@subparagraph[2]{}
\newcommand\listoffigures{%
    \if@twocolumn
      \@restonecoltrue\onecolumn
    \else
      \@restonecolfalse
    \fi
    \chapter*{\listfigurename
      \@mkboth{\listfigurename}%
              {\listfigurename}}%
    \@starttoc{lof}%
    \if@restonecol\twocolumn\fi
    }
\newcommand*\l@figure{\@dottedtocline{1}{1.5em}{2.3em}}
\newcommand\listoftables{%
    \if@twocolumn
      \@restonecoltrue\onecolumn
    \else
      \@restonecolfalse
    \fi
    \chapter*{\listtablename
      \@mkboth{%
          \listtablename}{\listtablename}}%
    \@starttoc{lot}%
    \if@restonecol\twocolumn\fi
    }
\let\l@table\l@figure
\newdimen\bibindent
\setlength\bibindent{1.5em}

%% Bibliography style defaults to chapter-style numbered for single author,
%% section-style numbered for multiple authored.

\newenvironment{thechapnumbibliography}[1]
     {\chapter*{\bibname}\markright{\bibname}%
      \list{\@biblabel{\@arabic\c@enumiv}}%
           {\settowidth\labelwidth{\@biblabel{#1}}%
            \leftmargin\labelwidth
            \advance\leftmargin\labelsep
			\itemsep0pt
            \@openbib@code
            \usecounter{enumiv}%
            \let\p@enumiv\@empty
            \renewcommand\theenumiv{\@arabic\c@enumiv}}%
      \sloppy
      \clubpenalty10000
      \@clubpenalty \clubpenalty
      \widowpenalty10000%
      \sfcode`\.\@m}
     {\def\@noitemerr
       {\@latex@warning{Empty `thebibliography' environment}}%
      \endlist}

\newenvironment{thesecnumbibliography}[1]
     {\section*{\bibname}%\if@contrib\else\markright{\bibname}\fi
      \list{\@biblabel{\@arabic\c@enumiv}}%
           {\settowidth\labelwidth{\@biblabel{#1}}%
            \leftmargin\labelwidth
            \advance\leftmargin\labelsep
			\itemsep0pt
            \@openbib@code
            \usecounter{enumiv}%
            \let\p@enumiv\@empty
            \renewcommand\theenumiv{\@arabic\c@enumiv}}%
      \sloppy
      \clubpenalty10000
      \@clubpenalty \clubpenalty
      \widowpenalty10000%
      \sfcode`\.\@m}
     {\def\@noitemerr
       {\@latex@warning{Empty `thebibliography' environment}}%
      \endlist}

\def\nonumbibitem#1{\item }

\newenvironment{thechapnonumbibliography}[1]
     {\chapter*{\bibname}\markright{\bibname}%
      \list{}%
           {\labelwidth0pt
            \leftmargin\parindent
            \itemindent-\parindent
			\itemsep0pt
            \@openbib@code}
      \sloppy
      \clubpenalty10000
      \@clubpenalty \clubpenalty
      \widowpenalty10000%
      \sfcode`\.\@m
	\let\bibitem\nonumbibitem
	}
     {\def\@noitemerr
       {\@latex@warning{Empty `thebibliography' environment}}%
      \endlist}

\newenvironment{thesecnonumbibliography}[1]
     {\section*{\bibname}%\if@contrib\else\markright{\bibname}\fi
      \list{}%
           {\labelwidth0pt
            \leftmargin\parindent
            \itemindent-\parindent
			\itemsep0pt
            \@openbib@code}
      \sloppy
      \clubpenalty10000
      \@clubpenalty \clubpenalty
      \widowpenalty10000%
      \sfcode`\.\@m
	\let\bibitem\nonumbibitem
	}
     {\def\@noitemerr
       {\@latex@warning{Empty `thebibliography' environment}}%
      \endlist}

\newcommand\newblock{\hskip .11em\@plus.33em\@minus.07em}
\let\@openbib@code\@empty
\newenvironment{theindex}
               {\if@twocolumn
                  \@restonecolfalse
                \else
                  \@restonecoltrue
                \fi
                \columnseprule \z@
                \columnsep 35\p@
                \twocolumn[\@makeschapterhead{\indexname}]%
                \@mkboth{\indexname}%
                        {\indexname}%
                \thispagestyle{plain}\parindent\z@
                \parskip\z@ \@plus .3\p@\relax
                \small
				\let\item\@idxitem}
               {\if@restonecol\onecolumn\else\clearpage\fi}
\newcommand\@idxitem{\par\hangindent 2em}
\newcommand\subitem{\@idxitem \hspace*{1em}}
\newcommand\subsubitem{\@idxitem \hspace*{2em}}
\newcommand\indexspace{\par \vskip 10\p@ \@plus5\p@ \@minus3\p@\relax}
\newcommand\newalpha[1]{\par \vskip 10\p@ \@plus5\p@ \@minus3\p@
	\textbf{#1}\relax}
\renewcommand\footnoterule{%
  %\kern-3\p@
	\vskip18\p@ plus8\p@ minus8\p@
  \hrule\@width5pc
  \kern2.6\p@}
\@addtoreset{footnote}{chapter}
\newcommand\@makefntext[1]{%
    \parindent 18\p@
    \noindent
    %\hb@xt@18pt{\hss\@makefnmark}
	\hb@xt@18pt{\hfill}%
	\@makefnmark\relax#1}
\newcommand\contentsname{Contents}
\newcommand\listfigurename{List of Figures}
\newcommand\listtablename{List of Tables}
\if@contrib
	\newcommand\bibname{References}
\else
	\newcommand\bibname{Bibliography}
\fi
\newcommand\indexname{Index}
\newcommand\figurename{FIGURE}
\newcommand\tablename{TABLE}
\newcommand\partname{Part}
\newcommand\chaptername{Chapter}
\newcommand\appendixname{Appendix}
\def\today{\ifcase\month\or
  January\or February\or March\or April\or May\or June\or
  July\or August\or September\or October\or November\or December\fi
  \space\number\day, \number\year}
\setlength\columnsep{10\p@}
\setlength\columnseprule{0\p@}
\pagestyle{headings}
\pagenumbering{arabic}
\if@twoside
\else
  \raggedbottom
\fi
\if@twocolumn
  \twocolumn
  \sloppy
  \flushbottom
\else
  \onecolumn
\fi

\ifbibundeclared%
	\if@contrib% % default is secnumbib
		\let\thebibliography\thesecnumbibliography
		\let\endthebibliography\endthesecnumbibliography
	\else % default is chapnumbib
		\let\thebibliography\thechapnumbibliography
		\let\endthebibliography\endthechapnumbibliography
\fi\fi

%%
%% CUSTOMIZATIONS
%%

\def\enumerate{\@ifnextchar [{\opargenum}{\defaultenum}}

\def\opargenum[#1]{\ifnum \@enumdepth >3 \@toodeep\else
      \advance\@enumdepth \@ne
      \edef\@enumctr{enum\romannumeral\the\@enumdepth}\list
      {\csname label\@enumctr\endcsname}{\usecounter
        {\@enumctr}%
	\labelsep.5em
	\settowidth\labelwidth{#1}
	\leftmargin\labelwidth
		\advance\leftmargin\labelsep
	\itemsep0pt
	\def\makelabel##1{\hss\llap{##1}}}\fi}

\def\defaultenum{\ifnum \@enumdepth >3 \@toodeep\else
      \advance\@enumdepth \@ne
      \edef\@enumctr{enum\romannumeral\the\@enumdepth}\list
      {\csname label\@enumctr\endcsname}{\usecounter
        {\@enumctr}%
	\labelsep.5em
	\ifcase\@enumdepth\or
		\settowidth\labelwidth{1.}\message{FIRST}\or
		\settowidth\labelwidth{(b)}\message{SECOND}\or
		\settowidth\labelwidth{ii.}\message{THIRD}\fi
	\leftmargin\labelwidth\advance\leftmargin by\labelsep
	\itemsep0pt
	\def\makelabel##1{\hss\llap{##1}}}\fi}
\let\endenumerate =\endlist

\def\itemize{%
  \ifnum \@itemdepth >3 \@toodeep\else \advance\@itemdepth \@ne
  \edef\@itemitem{labelitem\romannumeral\the\@itemdepth}%
  \list{\csname\@itemitem\endcsname}%
       {\settowidth\labelwidth{\csname\@itemitem\endcsname}%
		\labelsep.5em
		\leftmargin\labelwidth\advance\leftmargin\labelsep
		\def\makelabel##1{\rlap{##1}\hss}}\fi}
\let\enditemize =\endlist

\def\@begintheorem#1#2{\trivlist
   \item[\hskip \labelsep{\sffamily #1\ #2}.]\itshape}
\def\@opargbegintheorem#1#2#3{\trivlist
      \item[\hskip \labelsep{\sffamily #1\ #2\ \rmfamily(#3).}]\itshape}

\def\eqnarray{%
   \stepcounter{equation}%
   \def\@currentlabel{\p@equation\theequation}%
   \global\@eqnswtrue
   \m@th
   \global\@eqcnt\z@
   \tabskip\@centering
   \let\\\@eqncr
   $$\everycr{}\halign to\displaywidth\bgroup
       \hskip\@centering$\displaystyle\tabskip\z@skip{##}$\@eqnsel
      &\global\@eqcnt\@ne \hfil${{}##{}}$\hfil
      &\global\@eqcnt\tw@
         $\displaystyle{##}$\hfil\tabskip\@centering
      &\global\@eqcnt\thr@@ \hbox to\z@\bgroup\hss##\egroup
         \tabskip\z@skip
      \cr
}
%% Real Books use French spacing
\frenchspacing

%% Disallow widows and orphans
\widowpenalty=10000
\clubpenalty=10000

%%Add special definitions for dates 11-24-98
\newcommand{\ad}{\footnotesize{A.D.}}
\newcommand{\bc}{\footnotesize{B.C.}}
\newcommand{\bp}{\footnotesize{B.P.}}


\endinput
%%
%% End of file `book.cls'.
