function g = modeval()
% This tool derives the odes of the dynamical system
% emerging from the governing equations of the Rayleigh-Benard convection
% written for the 6D case!
% Maple engine required!
clc
clear all
close all
% Declaration of variables

syms psif psi thetaf thetaa thetab x z q t momentum energy u w lap2 lap4 sigma Ra izmom ixmom ixenA izenA ixenB izenB eq
syms psi1 psi2 x Xd y Yd z Zd u Ud v Vd w Wd r
% Declaration of structure

% How many modes per amplitude are to be considered?
num_mod = 2;
% Apart from the Lorenz modes which modes are to be considered?
psi_mod = [1 0; 2 0];
thetaa_mod = [1 0; 2 0];
thetab_mod = [0 1;0 2];
% q = sym('sqrt(1/2)*pi');
psi = sym(zeros(1, num_mod));
thetaa = sym(zeros(1, num_mod));
thetab = sym(zeros(1, num_mod));

for k=1:num_mod
  psi(k) = sym(sprintf('psi%d(t)', k));
  thetaa(k) = sym(sprintf('thetaA%d(t)', k));
  thetab(k) = sym(sprintf('thetaB%d(t)', k));
end

for k=1:3*num_mod
    eq(k) = sym(sprintf('eq%d', k));
end

psif = 0; 
thetaf = 0;

% define psi and theta
for i=1:num_mod
    psif = psif + psi(i)*sin(psi_mod(i,1)*q*x)*cos(pi*(2*psi_mod(i,2)+1)*z);
    thetaf = thetaf + thetaa(i)*cos(thetaa_mod(i,1)*q*x)*cos(pi*(2*thetaa_mod(i,2)+1)*z) + thetab(i)*cos(thetab_mod(i,1)*q*x)*sin(2*pi*thetab_mod(i,2)*z);
end

u = -diff(psif,z);
w = diff(psif,x);
lapp2 = diff(w,x)-diff(u,z);
lapp4 = diff(lapp2,z,2) + diff(lapp2,x,2);
lapt2 = diff(thetaf,x,2) + diff(thetaf,z,2);

% define Momentum Balance and Energy Balance
momentum = 1/sigma*(-diff(lapp2,t)+diff(u*diff(u,x)+w*diff(u,z),z)-diff(u*diff(w,x)+w*diff(w,z),x))+lapp4+diff(thetaf,x);
energy = diff(thetaf,t)+u*diff(thetaf,x)+w*diff(thetaf,z)-lapt2 - Ra*diff(psif,x);

% integrate
shift = 0;
for i=1:num_mod
    izmom = int(momentum*sin(psi_mod(i,1)*q*x)*cos(pi*(2*psi_mod(i,2)+1)*z),z,-1/2,1/2);
    ixmom = int(izmom,x,0,pi/q);
    eq(1+shift) = ixmom;
    izenA = int(energy*cos(thetaa_mod(i,1)*q*x)*cos(pi*(2*thetaa_mod(i,2)+1)*z),z,-1/2,1/2);
    ixenA = int(izenA,x,0,pi/q);
    eq(2+shift) = ixenA;
    izenB = int(energy*cos(thetab_mod(i,1)*q*x)*sin(2*pi*thetab_mod(i,2)*z),z,-1/2,1/2);
    ixenB = int(izenB,x,0,pi/q);
    eq(3+shift) = ixenB;
    shift = 3;
end
equ1=subs(eq(1),{diff(psi(1),t),psi(1),psi(2),thetaa(1),thetaa(2),thetab(1),thetab(2),sigma,Ra,q},{Xd,x,u,y,v,z,w,10,5*(3/2*pi^2)^3/q^2,double(sqrt(1/2)*pi)});
equ2=subs(eq(2),{diff(thetaa(1),t),psi(1),psi(2),thetaa(1),thetaa(2),thetab(1),thetab(2),sigma,Ra,q},{Yd,x,u,y,v,z,w,10,5*(3/2*pi^2)^3/q^2,double(sqrt(1/2)*pi)});
equ3=subs(eq(3),{diff(thetab(1),t),psi(1),psi(2),thetaa(1),thetaa(2),thetab(1),thetab(2),sigma,Ra,q},{Zd,x,u,y,v,z,w,10,5*(3/2*pi^2)^3/q^2,double(sqrt(1/2)*pi)});
equ4=subs(eq(4),{diff(psi(2),t),psi(1),psi(2),thetaa(1),thetaa(2),thetab(1),thetab(2),sigma,Ra,q},{Ud,x,u,y,v,z,w,10,5*(3/2*pi^2)^3/q^2,double(sqrt(1/2)*pi)});
equ5=subs(eq(5),{diff(thetaa(2),t),psi(1),psi(2),thetaa(1),thetaa(2),thetab(1),thetab(2),sigma,Ra,q},{Vd,x,u,y,v,z,w,10,5*(3/2*pi^2)^3/q^2,double(sqrt(1/2)*pi)});
equ6=subs(eq(6),{diff(thetab(2),t),psi(1),psi(2),thetaa(1),thetaa(2),thetab(1),thetab(2),sigma,Ra,q},{Wd,x,u,y,v,z,w,10,5*(3/2*pi^2)^3/q^2,double(sqrt(1/2)*pi)});
g(1) = simple(solve(equ1,Xd));
g(2) = simple(solve(equ2,Yd));
g(3) = simple(solve(equ3,Zd));
g(4) = simple(solve(equ4,Ud));
g(5) = simple(solve(equ5,Vd));
g(6) = simple(solve(equ6,Wd));

