function field_sim(t,v,dim)
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %
% This tool simulates the resluting Flow and Temperature field       %
% Input variables:                                                   %
% v     -       field of amplitudes                                  %
% t     -       corresponding time vector                            %
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %
syms x z
q = pi/sqrt(2);
Ra = 27*pi^4/4;
m = [1 1 0 1 1 0 1 1 0];
n = [1 1 2 2 2 4 3 3 6];
for i=1:length(t)
    psi = v(i,(1))*sin(m(1)*q*x)*cos(pi*(2*n(1)+1)*z)+v(i,(4))*sin(m(4)*q*x)*cos(pi*(2*n(4)+1)*z)+v(i,(7))*sin(m(7)*q*x)*cos(pi*(2*n(7)+1)*z);
    theta = v(i,2)*cos(m(2)*q*x)*cos(pi*(2*n(2)+1)*z)-1 + v(i,(3))*cos(m(3)*q*x)*sin(2*pi*n(3)*z)+ ...
        v(i,5)*cos(m(5)*q*x)*cos(pi*(2*n(5)+1)*z)-1 + v(i,(6))*cos(m(6)*q*x)*sin(2*pi*n(6)*z)+ ...
        v(i,8)*cos(m(8)*q*x)*cos(pi*(2*n(8)+1)*z)-1 + v(i,(9))*cos(m(9)*q*x)*sin(2*pi*n(9)*z);
    figure(30), clf
    subplot(2,1,1);
    hold on
    ezplot(psi-1, [0 pi/q -1/2 1/2]);
    ezplot(psi-1.5, [0 pi/q -1/2 1/2]);
    ezplot(psi-2, [0 pi/q -1/2 1/2]);
    title('Velocity field');
    xlabel('x');
    ylabel('z');
    hold off
    
    subplot(2,1,2);
    hold on
    ezplot(theta-1, [0 pi/q -1/2 1/2]);
    ezplot(theta-1.5, [0 pi/q -1/2 1/2]);
    ezplot(theta-2, [0 pi/q -1/2 1/2]);
    title('Temperature field');
    xlabel('x');
    ylabel('z');
    hold off
end