function [diss, dlyap h_mu] = Lorenz9_lyan(lyap,dim)
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %
% This tool calculates the Lyapunov exponent of the Lorenz 9D        %
% Input variables:                                                   %
% dim          -              Dimension of the system                %
% lyap         -              Lyapunov matrix                        %
% By Franz Bozsak                                                    %
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %
% declaration
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %

kmax  = length(lyap(1,:));
dlyap = zeros(kmax);
diss  = zeros(kmax);
h_mu  = zeros(kmax);

for k=1:kmax
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %
% Calculate the dissipation rate                                     %
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %

    diss(k) = sum(lyap(:,k));
    
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %
% Calculate the entropy rate                                         %
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %
    
    for j=1:dim
        if lyap(j,k) > 0
            h_mu(k) = h_mu(k) + lyap(j,k);
        end
    end

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %
% Calculate the lyapunov dimesion of the attractor                   %
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %

    if lyap(1,k) < 1
        dlyap(k) = 0;
    elseif (diss(k) > 0)
        dlyap(k) = dim + diss(k);
    else
        lysum = lyap(1,k);
        i = 2;
        while (lysum+lyap(i,k)) >= 0
            lysum = lysum + lyap(i,k);
            i = i + 1;
        end
        dlyap(k) = (i-1) + lysum/abs(lyap(i,k));
    end 
end
            