#Slide 0.71 a simple slideshow program
#Copyright (C) 2004  Giorgos Tzambanakis
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#The author can be reached at psymaster@caths.co.uk

from Tkinter import*

import slide7
import sys
from os import getcwd

def start_slide(event=0): #the default is there because if the button is pressed no parameter is passed
    global editbox_list
    global fs,rnd
    global int_edit
    global root
    global fs_check
    
    rootdir_list=[]
    for editbox in editbox_list:
        rootdir_list.append(editbox.get())
    interval = float(int_edit.get())
    root.withdraw()

    inifile = open(getcwd() + "/slide.ini", "w")
    for rootdir in rootdir_list:
        inifile.write(rootdir + "\n")
    inifile.close()
    
    try:
        slide7.main(rootdir_list, interval, fs.get(), rnd.get())
    except RuntimeError, inst:
        sys.exit()
    root.deiconify()
    

##def edit_fill(event):
##    global editbox_list
##    number = int(event.keysym[1])-1
##    if number == 0:        
##        editbox_list[number].delete(0,END)
##        editbox_list[number].insert(END, "") #these can be used to add presets
##    elif number == 1:
##        editbox_list[number].delete(0,END)
##        editbox_list[number].insert(END, "")
##    elif number == 2:
##        editbox_list[number].delete(0,END)
##        editbox_list[number].insert(END, "")




inifile = open(getcwd() + "/slide.ini", "r") #this is the file that will hold the last selected directories
inifile_lines = inifile.readlines()
inifile.close()


root = Tk()
root.resizable(width=0,height=0)
root.title("Slide")
root.bind("<Return>", start_slide)
root.bind("<Escape>", sys.exit)
##root.bind("<F1>", edit_fill)
##root.bind("<F2>", edit_fill)
##root.bind("<F3>", edit_fill)
##root.bind("<F4>", edit_fill)
##root.bind("<F5>", edit_fill)
##root.bind("<F6>", edit_fill)

top_frame = Frame(root)
top_frame.grid(padx = 4, pady = 3) #so that frame will cover all the window

dir_label = Label(top_frame, text = "Dirs to use:")
dir_label.grid(column=1,row=1)

editbox_list=[]
for i in range(6):
    editbox_list.append(Entry(top_frame))
    editbox_list[i].grid(column=1, row=i+2, columnspan=2)
    editbox_list[i].insert(END, inifile_lines[i][:-1]) # to keep "\n" from appearing in the string

int_label = Label(top_frame, text = "Interval in s:")
int_label.grid(column=1, row=8, sticky=W)
int_edit = Entry(top_frame, width=4)
int_edit.insert(END, "1.8")
int_edit.grid(column=2, row=8, sticky=W)


fs = IntVar()
fs_check = Checkbutton(top_frame, text="Fullscreen", variable=fs)
fs_check.grid(column=1, row=9, sticky=W) 

rnd = IntVar()
rnd_check = Checkbutton(top_frame, text="Shuffle images", variable=rnd)
rnd_check.select()
rnd_check.grid(column=1, row=10, sticky=W)


button = Button(top_frame, text = "Start!", command = start_slide) 
button.grid(column=1, row=11, columnspan=1)



root.mainloop()


