import os.path

class Recorder:
    def __init__(self, dir):
        self.files = {}
        self.dir = dir

    def file(self, key):
        if not self.files.has_key(key):
            # open a file
            filename = os.path.join(self.dir, key + ".data")
            self.files[key] = open(filename, 'w')
        return self.files[key]

    def writeData(self, data):
        for key,value in data.items():
            self.file(key).write("%f\n" % value)
            self.file(key).flush()

    

