# Integrators.py

from numpy import *
from Shane import *

# This looks like 1D integrator, but it's a 3D integrator if numpy
# arrays (vectors) are used.
def Euler3DIntegrator(f,x,dt):
  #return x + dt * f(x)
  return dt * f(x)

# 3D integrator if numpy arrays (vectors) are used.
def RK3DIntegrator(f,x,dt):
	k1 = dt * f(x)
	k2 = dt * f(x + k1 / 2.0)
	k3 = dt * f(x + k2 / 2.0)
	k4 = dt * f(x + k3)
        #return x + ( k1 + 2.0 * k2 + 2.0 * k3 + k4 ) / 6.0
        return ( k1 + 2.0 * k2 + 2.0 * k3 + k4 ) / 6.0

integrators = [Euler3DIntegrator, RK3DIntegrator]
