# MatrixIO.py

from types import *
from numpy import *
from Scientific.IO.TextFile import TextFile

def readMatrix(filename):
    count = None
    rows = []
    for line in TextFile(filename):
        line = line.strip()
        if line == '':
            continue
        elements = map(float, line.split())
        if count == None:
            count = len(elements)
        elif count != len(elements):
            raise "different number of elements in matrix row"
        rows.append(elements)
    return array(rows)

def writeMatrix(a, out):
    for row in a:
        for element in row:
            out.write(str(element) + " ")
        out.write("\n")

def printMatrix(a, filename):
    out = open(filename, 'w')
    writeMatrix(a, out)
    out.close()
