# This is module ODES.py and contains the
# Ordinary Differential equations necessary
# for investigating the fluid particle motion
# inside a nuetrually bouyant dropplet.

# The 3D ODEs dictating the fluid particles velocity
def DxDt(alpha,wx,wy,wz,x,y,z):
   r2   = x**2  + y**2 + z**2
   ap1  = 1.0 + alpha
   trm1 = (5.0*r2 - 3.0)*x/ap1
   trm2 = 2*x*((x**2 + alpha*y**2)/ap1 - z**2)
   trm3 = wy*z - wz*y
   u    = 0.5*(trm1 - trm2 + trm3) 
   return u

def DyDt(alpha,wx,wy,wz,x,y,z):
   r2   = x**2  + y**2 + z**2
   ap1  = 1.0 + alpha
   trm1 = (5.0*r2 - 3.0)*alpha*y/ap1
   trm2 = 2*y*((x**2 + alpha*y**2)/ap1 - z**2)
   trm3 = wz*x - wx*z
   v    = 0.5*(trm1 - trm2 + trm3) 
   return v

def DzDt(alpha,wx,wy,wz,x,y,z):
   r2   = x**2  + y**2 + z**2
   ap1  = 1.0 + alpha
   trm1 = -(5.0*r2 - 3.0)*z
   trm2 = 2*z*((x**2 + alpha*y**2)/ap1 - z**2)
   trm3 = wx*y - wy*x
   w    = 0.5*(trm1 - trm2 + trm3) 
   return w

def ChaoticDropNameString():

   name = 'Chaotic Droplet ' 
   return name

# define Rossler initial conditions
def ChaoticDropCondition():

   a    = 1.0
   dt   = 0.01
   iter = 5000000
   x0   = 0.1
   y0   = 0.0
   z0   = 0.0
   wy   = 0.0
   print 'Alpha,wx,wy,wz,x0,y0,z0,dt,iter,dt,timesteps'
   print a,",",0.0      ,",",wy,",",0.0        ,",",x0,",",y0,",",z0,",",dt,",",iter
   print a,",",0.2938900,",",wy,",",0.404508000,",",x0,",",y0,",",z0,",",dt,",",iter
   print a,",",0.5877850,",",wy,",",0.809016990,",",x0,",",y0,",",z0,",",dt,",",iter
   print a,",",0.6641973,",",wy,",",0.914189203,",",x0,",",y0,",",z0,",",dt,",",iter
   print a,",",0.6877100,",",wy,",",0.946549800,",",x0,",",y0,",",z0,",",dt,",",iter
   print a,",",0.7347000,",",wy,",",1.011270000,",",x0,",",y0,",",z0,",",dt,",",iter
   print a,",",0.8228990,",",wy,",",1.132600000,",",x0,",",y0,",",z0,",",dt,",",iter
   print a,",",1.0286000,",",wy,",",1.415770000,",",x0,",",y0,",",z0,",",dt,",",iter
   print a,",",1.4694600,",",wy,",",2.022540000,",",x0,",",y0,",",z0,",",dt,",",iter
   print a,",",2.3411400,",",wy,",",3.236067900,",",x0,",",y0,",",z0,",",dt,",",iter
   print a,",",4.7022820,",",wy,",",6.472135900,",",x0,",",y0,",",z0,",",dt,",",iter
   print a,",",0.0003142,",",wy,",",0.099999990,",",x0,",",y0,",",z0,",",dt,",",iter
   print a,",",0.0031410,",",wy,",",0.099999990,",",x0,",",y0,",",z0,",",dt,",",iter
   print a,",",0.0309000,",",wy,",",0.095150000,",",x0,",",y0,",",z0,",",dt,",",iter
   print a,",",0.0707106,",",wy,",",0.070710600,",",x0,",",y0,",",z0,",",dt,",",iter
   print a,",",0.0951056,",",wy,",",0.030901600,",",x0,",",y0,",",z0,",",dt,",",iter
   print a,",",0.0062831,",",wy,",",1.999999900,",",x0,",",y0,",",z0,",",dt,",",iter
   print a,",",0.0125662,",",wy,",",1.999961000,",",x0,",",y0,",",z0,",",dt,",",iter
   print a,",",0.0420942,",",wy,",",1.999556900,",",x0,",",y0,",",z0,",",dt,",",iter
   print a,",",0.0628215,",",wy,",",1.999013100,",",x0,",",y0,",",z0,",",dt,",",iter
   print a,",",0.1255810,",",wy,",",1.996053400,",",x0,",",y0,",",z0,",",dt,",",iter
   print a,",",1.1755700,",",wy,",",1.618033988,",",x0,",",y0,",",z0,",",dt,",",iter
   print a,",",1.9021130,",",wy,",",0.618033988,",",x0,",",y0,",",z0,",",dt,",",iter
   print a,",",1.9960530,",",wy,",",0.125581030,",",x0,",",y0,",",z0,",",dt,",",iter
   print a,",",2.0000000,",",wy,",",3.000000000,",",x0,",",y0,",",z0,",",dt,",",iter
   print a,",",2.0000000,",",wy,",",3.000000000,",",0.0,",",y0,",",z0,",",dt,",",iter
