# LorenzAttractorTSeries.py

#initial conditions
x=.1
y=0
z=20

dt=1.0/128
tmax=10    # maximum time to simulate

show_time_series=True

#-------------------------------------------------

from visual import *
from visual.graph import *

if show_time_series:
    graph = gdisplay(title="Time Series")
    xcurve = gcurve(color=color.red)
    ycurve = gcurve(color=color.yellow)
    zcurve = gcurve(color=color.green)

lorenzcurve = curve(radius=.1,color=(1,1,0))
currentpoint = sphere(radius=.7)

#these are the approximate bounds of the attractor
xmax=30;xmin=-25
ymax=30;ymin=-30
zmax=60;zmin=0

scene.center=((xmin+xmax)/2.0,(ymin+ymax)/2.0,(zmin+zmax)/2.0)

#draw a cube around the attractor
cubepoints=[ (xmin,ymin,zmin), #bottom
             (xmax,ymin,zmin),
             (xmax,ymax,zmin),
             (xmin,ymax,zmin),
             (xmin,ymin,zmin),

             (xmin,ymin,zmax), #top
             (xmax,ymin,zmax),
             (xmax,ymax,zmax),
             (xmin,ymax,zmax),
             (xmin,ymin,zmax),

             (xmax,ymin,zmax), # remaining edges 
             (xmax,ymin,zmin),
             (xmax,ymax,zmin),             
             (xmax,ymax,zmax),             
             (xmin,ymax,zmax),
             (xmin,ymax,zmin) ]
         
curve(pos=cubepoints,color=color.red)


t=0
pointcount=0

while t<=tmax:

    lorenzcurve.append(pos=(x,y,z))
    currentpoint.pos=(x,y,z)

    if show_time_series:
        xcurve.plot(pos=(t,x))
        ycurve.plot(pos=(t,y))
        zcurve.plot(pos=(t,z))

    # curves start to look bad with more than 512 points so start a new one
    pointcount+=1
    if pointcount>511:
        lorenzcurve = curve(pos=[(x,y,z)],radius=.1,color=(1,1,0))
        pointcount=0

    xprime = -10*x + 10*y
    yprime = -x*z +28*x - y
    zprime =  x*y -  8.0/4* z

    x += xprime*dt
    y += yprime*dt
    z += zprime*dt

    t += dt

    rate(90) # slow down drawing so we can watch it evolve
    
