#!/usr/bin/env python

# import modules
from ODEGen import *
from ODES import *

# Print Welcome screen for user and a list of 
# avaliable map functions
print """
Welcome to Chaotic Droplet.
Please choose from the following:
"""
print """
1 - 2D Poincare Map
2 - 2D Poincare Map using VPython
3 - 3D Streamline
4 - 3D Streamline + 2D Poincare map
5 - 3D Particle Tracking
6 - 3D Particle Tracking w/ History (One Point)
7 - 3D Particle Tracking w/ History (Two Points)
8 - Generate Lyapunov Characteristic Exponents
9 - Automated Poincare Map Generation
"""
nplt = input()

if nplt < 9:
   print """
   Please enter the parameter range separated by commas
   alpha, omega x, omega y, omega z, x, y, z, dt, timesteps
   """
   print """
   Do you want to first see some intereting parameters?
   1 - Yes
   2 - No
   """
   nprm  = input()
   if nprm == 1:
      ChaoticDropCondition()
      print """
      You can choose from the above parameters
      by coping and pasting
      """
   # Enter input parameters
   alpha,wx,wy,wz,x,y,z,dt,iter   = input()

# Generate Title
title = ChaoticDropNameString()

# call Generate function
if nplt == 1:
   print """
   1 - Display figure to screen
   2 - Save figure to *.ps file
   """
   nplot = 1
   nplot = input()
   PoincareMap(DxDt,DyDt,DzDt,title,alpha,wx,wy,wz,x,y,z,dt,iter,nplot)
elif nplt == 2:
   GenPCurve(DxDt,DyDt,DzDt,title,alpha,wx,wy,wz,x,y,z,dt,iter)
elif nplt == 3:
   GenerateCurve(DxDt,DyDt,DzDt,title,alpha,wx,wy,wz,x,y,z,dt,iter,0)
elif nplt == 4:
   GenerateCurve(DxDt,DyDt,DzDt,title,alpha,wx,wy,wz,x,y,z,dt,iter,1)
elif nplt == 5:
   GenerateDotSpread(DxDt,DyDt,DzDt,title,alpha,wx,wy,wz,x,y,z,dt,iter)
elif nplt == 6:
   GenerateDotHistory(DxDt,DyDt,DzDt,title,alpha,wx,wy,wz,x,y,z,dt,iter)
elif nplt == 7:
   GenerateDotHistory2(DxDt,DyDt,DzDt,title,alpha,wx,wy,wz,x,y,z,dt,iter)
elif nplt == 8:
   print """
   1 - Display figure to screen
   2 - Save figure to *.ps file
   """
   nplot = 1
   nplot = input()
   GenerateLCE(DxDt,DyDt,DzDt,title,alpha,wx,wy,wz,x,y,z,dt,iter,nplot)
elif nplt == 9:
   print """
   Please enter the parameter range separated by commas
   dt, timesteps
   """
   # Enter input parameters
   dt,iter   = input()

   GenerateAutoPoincareMap(DxDt,DyDt,DzDt,title,dt,iter)

# end program
