from glew import *
 
 # --  A simple class for using glsl shaders, the mooost basic set up possible
 # -- A sensible unit test would be to check for the availability of the extensions.
class glslBasic:
	
	def __init__(self):
		self.program = 0
		self.v		 = 0
		self.f		 = 0

		
	def buildObject(self, _prog, _type):
		obj=glCreateShaderObjectARB(_type)
		glShaderSourceARB(obj, 1, [_prog])
		glCompileShaderARB(obj)
		print 'Object:', glGetObjectParameterivARB(obj, GL_OBJECT_COMPILE_STATUS_ARB)
		print 'Object:', glGetInfoLogARB(obj)
		return obj

		
	def load(self, _vert, _frag):
		self.program = glCreateProgramObjectARB()
		if _vert:
			self.v = self.buildObject(_vert, GL_VERTEX_SHADER_ARB)
			glAttachObjectARB(self.program, self.v)
		
		if _frag:
			self.f = self.buildObject(_frag, GL_FRAGMENT_SHADER_ARB)
			glAttachObjectARB(self.program, self.f)

		glLinkProgramARB(self.program)
		print glGetInfoLogARB(self.program)

		
	def clearUp(self):
		glDetachObjectARB(self.program,self.v);
		glDetachObjectARB(self.program,self.f);
		
		glDeleteObjectARB(self.v);
		glDeleteObjectARB(self.f);
		glDeleteObjectARB(self.program);

		
	def use(self):
		glUseProgramObjectARB(self.program)
	
	def end(self):
		glUseProgramObjectARB(0)
	
	def getAttribIndex(self,_name):
		return  glGetAttribLocationARB(self.program, _name)
	
	def getUniformIndex(self,_name):
		return glGetUniformLocationARB(self.program, _name)
	
	def setUniform1i(self, _u, _v):
		glUniform1iARB(_u, _v)
	
	def setUniform1f(self, _u, _v):
		glUniform1fARB(_u, _v)
	
	def setUniform4fv(self, _u, _v):
		glUniform4fvARB(_u, 4, _v)
		
	def setUniform4f(self, _u, _x, _y, _z, _w):
		glUniform4fARB(_u, _x, _y, _z, _w)