from OpenGL.GL import *
from array import *

def drawSquare(_n):
	glBegin(GL_QUADS)
	glTexCoord2f(0.0,	0.0)
	glVertex2i	(0,		0)
	glTexCoord2f(0.0,	1.0)
	glVertex2i	(0,		_n)
	glTexCoord2f(1.0,	1.0)
	glVertex2i	(_n,	_n)
	glTexCoord2f(1.0,	0.0)
	glVertex2i	(_n,	0)
	glEnd()
	
	
def createEmptyTextureSquare(_n, _filter=GL_NEAREST, _wrap=GL_REPEAT):
	# -- No mipmap support
	# -- Use _wrap= GL_CLAMP for hw np2 on ati cards
	t = glGenTextures(1)
	glBindTexture(GL_TEXTURE_2D, t)
	
	d=array('B')	
	for a in range(_n*_n):
		d.append(a%256)
	
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, _wrap)
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, _wrap)
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, _filter)
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, _filter)
	
	glTexImage2D(GL_TEXTURE_2D, 0, 4, _n, _n, 0, GL_LUMINANCE, GL_UNSIGNED_BYTE, d.tostring())
	
	return t