from OpenGL.GL import *
from OpenGL.GLUT import *
from array import *


class timeSeries1d:

	def __init__(self, _x, _y):
		glEnable(GL_TEXTURE_2D)
		self.tex = glGenTextures(1)
		glBindTexture(GL_TEXTURE_2D, self.tex)
		b=array('f')		
		for a in range(_x*_y):
			b.append(0.0)
#		glCopyTexImage2D (GL_TEXTURE_2D, 0, GL_RGB, 0, 0, _x, _y, 0) 
		glTexImage2D(GL_TEXTURE_2D, 0, 3, _x, _y, 0,GL_LUMINANCE, GL_FLOAT, b.tostring())
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP)## Allows np2 texture on lower hardware
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP)
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST)
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST)

		self.x = _x
		self.y = _y
		self.r = 0
		
	def update(self, _data):
		#if data len >> ERROR!
		glEnable(GL_TEXTURE_2D)
		glBindTexture(GL_TEXTURE_2D, self.tex)
		b=array('f',_data)
		glTexSubImage2D(GL_TEXTURE_2D,0, 0,self.r, self.x,1, GL_LUMINANCE, GL_FLOAT, b.tostring())
		self.r+=1
		self.r%=self.y
		glDisable(GL_TEXTURE_2D)
		
		
	def plot(self, _scale=2):
	# -- quick paramaterless plot
		glEnable(GL_TEXTURE_2D)
		glBindTexture(GL_TEXTURE_2D, self.tex)
		glBegin(GL_QUADS)
		glTexCoord2f(0.0,0.0)
		glVertex2i(0,0)

		glTexCoord2f(0.0,1.0)
		glVertex2i(0,self.y)

		glTexCoord2f(1.0,1.0)
		glVertex2i(self.x*_scale,self.y)

		glTexCoord2f(1.0,0.0)
		glVertex2i(self.x*_scale,0)
		glEnd()
		glDisable(GL_TEXTURE_2D)
	
	
def linePlot(_points, _c=[1.0,1.0,1.0,1.0], _xscale=4, _yscale=200.0):		
	
		glEnable(GL_BLEND)
		glBlendFunc(GL_DST_COLOR,GL_SRC_ALPHA)
		glBegin(GL_QUADS)
		glColor4f(0.0,0.0,0.0,0.95)# -- Make te line a diferent colour?
		glVertex2f(0.0,0.0)
		glVertex2f(0.0,2*_yscale)
		glVertex2f(64*_xscale,2*_yscale)
		glVertex2f(64*_xscale,0.0)
		glEnd()
		glDisable(GL_BLEND)
		
		glColor4fv(_c)
		glBegin(GL_LINE_STRIP)
		for i in range(len(_points)):
			glVertex2f(i*_xscale,_points[i]*_yscale)
		glEnd()