# -- Simple Difference of luminance data, [red,blue]=[-1.0,+1.0],purple is neutral.
lumDifferencef = """
uniform sampler2D tex0, tex1;

void main()
{
	vec4  a = texture2D(tex0,gl_TexCoord[0].st);
	vec4  b = texture2D(tex1,gl_TexCoord[0].st);
	float d = a.r-b.r;
	d = 0.5+0.5*d;
	const vec4 red  = vec4(1.0,0.0,0.0,0.0);
	const vec4 blue = vec4(0.0,0.0,1.0,0.0);
	
	gl_FragColor = mix(red,blue,d);
}
"""

# -- Convert a 2d vector into a hue for visualisation of direction.
huef="""
uniform sampler2D tex;

void main()
{
	vec4 a= texture2D(tex,gl_TexCoord[0].st);

	float x = -1.0+2.0*a.r;
	float y = -1.0+2.0*a.a;

	float m = sqrt(x*x+y*y);
	
	float p = atan(y/x);

	if(x<0.0)
		p+=3.14;
	
	vec4 hue= vec4(
	m*cos(p),
	m*cos(p+4.18879),
	m*cos(p+2.09439),
	1.0
	);
	gl_FragColor = hue;
}
"""


# -- A 4*4 simple block average downsample ( I think its bugged)
block44f="""
uniform sampler2D tex;

void main()
{
	const float o = 1.0/256.0;
	const float s = 1.0/64.0;
	vec2 uv = gl_TexCoord[0].st-s*0.5;

	//vec4 a = texture2D(tex,uv);
	vec4 a= -1.0+2.0*texture2D(tex,uv+vec2(0.0,	 0.0));
	a+=  -1.0+2.0*texture2D(tex,uv+vec2(o,	 0.0));
	a+=  -1.0+2.0*texture2D(tex,uv+vec2(2.0*o, 0.0));
	a+=  -1.0+2.0*texture2D(tex,uv+vec2(3.0*o, 0.0));
	
	a+=  -1.0+2.0*texture2D(tex,uv+vec2(0.0,	 o));
	a+=  -1.0+2.0*texture2D(tex,uv+vec2(o,	 o));
	a+=  -1.0+2.0*texture2D(tex,uv+vec2(2.0*o, o));
	a+=  -1.0+2.0*texture2D(tex,uv+vec2(3.0*o, o));


	a+=  -1.0+2.0*texture2D(tex,uv+vec2(0.0,	 2.0*o));
	a+= -1.0+2.0*texture2D(tex,uv+vec2(o,	 2.0*o));
	a+=  -1.0+2.0*texture2D(tex,uv+vec2(2.0*o, 2.0*o));
	a+=  -1.0+2.0*texture2D(tex,uv+vec2(3.0*o, 2.0*o));

	a+=  -1.0+2.0*texture2D(tex,uv+vec2(0.0,	 3.0*o));
	a+=  -1.0+2.0*texture2D(tex,uv+vec2(o,	 3.0*o));
	a+=  -1.0+2.0*texture2D(tex,uv+vec2(2.0*o, 3.0*o));
	a+=  -1.0+2.0*texture2D(tex,uv+vec2(3.0*o, 3.0*o));

//	a.rgb/=a.a;
//	a.a/=16.0;
	gl_FragColor = 0.5+(0.5*a/16.0);
}
"""