import random

class caBase1d:
	def __init__(self, _size=2048, _navg=6):
		self.cells	= []
		self.avg	= []
		self.size	= _size
		self.navg	= _navg
		
		# -- HACK: -
		self.diff=1
		self.adv =1
		self.rD		=0.9
		self.rN		=100
		
		for i in range(_size):
			self.cells+=[0]
		for i in range(_size/(2*_navg)):
			self.avg+=[0]

	# -- Could use the proper accessors, but I'm lazy: -
	def getCells(self):
		return self.cells

	def getAverage(self):
		return self.avg

	# -- Internal utility: -
	def average(self, _n):
		a=[]
		b=[]
		for i in range(0,len(self.cells),2):
			a+=[0.25*(self.cells[i]+self.cells[i+1])]
		o=[]
	
		for j in range(_n-1):
			for i in range(0,len(a)-1,2):
				o+=[0.5*(a[i]+a[i+1])]
			a[:]=o[:]
			o=[]
		return a
			
	# -- The functions a derived class needs to define: -
	def evolve(self):
		pass
	
	# -- Public Inteface: -
	def update(self, _n=1):

		for i in range(_n):
			self.evolve()

		self.avg=self.average(self.navg)
	
	def setInitial (self, _in):
		pass
		
	


class ca1dDiffuse(caBase1d):# -- Just make to an even into odd type, defined by lut
		
	#lut=([0,0], [1,0], [0,2]), ([0,1], [1,1], [1,2]), ([2,0], [2,1], [1,1])# Advection?
	lutB=([0,0], [1,0], [0,2]), ([0,1], [2,2], [1,2]), ([2,0], [2,1], [1,1])# I changed the 12->12 rules to 12->21
	lutA=([0,0], [1,0], [0,2]), ([0,1], [2,2], [2,1]), ([2,0], [1,2], [1,1])
	lut = lutA
		
		#0,	1,	2
		#([0,0], [1,0],[0,2]),#0
		#([0,1], [2,2],[2,1]),#1
		#([2,0], [1,2], [1,1]) #2
		
	def setInitial (self, _in):
		delta	= self.size/(2*self.navg)
		states	= [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]	## only for navg = 3, size=2048
		b	=  0

		print self.size
		for i in range(1,self.size/2):
			if i%64==0:
				states[b]+=1
				b+=1
				b%=16
			self.cells[i]=states[i%16]
		
		for i in range(1,self.size/2):
			self.cells[i+self.size/2]=self.cells[self.size/2-i]

		self.avg=self.average(self.navg)
			
	def advect(self):
		# -- Lame advection, doesnt consider the values of each cell! so its non-non-linear.
		# -- Advect twice: -
		o=[]
		o+=[self.cells[self.size-1]]
		for i in range(1,self.size, 1):
			o+=[self.cells[i-1]]

		self.cells[0]=o[self.size-1]
		for i in range(1,self.size, 1):
			self.cells[i]=o[i-1]
			
	def diffuseLut(self):			
		# -- Even: -
		o=[]
		for i in range(0,self.size, 2):
			a=self.cells[i]
			b=self.cells[i+1]	# -- What I'd give for a pointer.	
			a, b = self.lut[a][b]
			o+=[a]+[b]
			
		# -- Odd: -
		for i in range(1,self.size-2, 2):
			a=o[i]
			b=o[i+1]	
			self.cells[i], self.cells[i+1] = self.lut[a][b]	
			
		self.cells[0]=o[self.size-1]
		self.cells[self.size-1]=o[0]
	
	def diffuseR(self):
		# -- Even: -
		o=[]
		for i in range(0,self.size, 2):
			a=self.cells[i]
			b=self.cells[i+1]	# -- What I'd give for a pointer.	
			if random.random() < self.rD:
				o+=[b]+[a]
			else:
				o+=[a]+[b]
			
		# -- Odd: -
		for i in range(1,self.size-2, 2):
			a=o[i]
			b=o[i+1]
			if random.random() < self.rD:
				self.cells[i], self.cells[i+1] = b,a
			else:
				self.cells[i], self.cells[i+1] = a,b	
		
		if random.random() < self.rD:		
			self.cells[0]=o[self.size-1]
			self.cells[self.size-1]=o[0]
		else:
			self.cells[0]=o[0]
			self.cells[self.size-1]=o[self.size-1]
			
	def evolve(self):
	
		if self.diff == 1:
			self.diffuseLut()
		if self.diff == 2:
			for i in range(self.rN):
				self.diffuseR()
		
		if self.adv == 1:
			self.advect()
		
if __name__ == '__main__':
	print 'Nothing'
	a = ca1dDiffuse()
	a.setInitial(0)

	print a.getCells()
	print a.getAverage()
#	for i in range(100):
#		a.update()
#		print a.getAverage()