from OpenGL.GL import *
from OpenGL.GLUT import *	
from glew import *

from glslBasic import *
from glBasic import *

from ca2d import *

import caShaders

global tex256, ca, sBlock44, tex64, tex16, sHue


def display():
	global tex256, ca, sBlock44, tex64, tex16, sHue
		
	# -----------------------------------
	# -- Update the system: -
	# -----------------------------------
	ca.evolve()
	ca.setBlock(118,40,32,10,1)
	ca.setBlock(118,40,256-32,10,3)
	
	ca.setBlock(32,10,108,20,2)
	ca.setBlock(256-32,10,128,20,4)
	
	# -----------------------------------
	# -- Visualise: -
	# -----------------------------------
	glLoadIdentity()
	glEnable(GL_TEXTURE_2D)
	glBindTexture(GL_TEXTURE_2D, tex256)
	
	# -- Block Average: -
	sBlock44.use()
	
#	c=ca.colour()
#	glTexSubImage2D(GL_TEXTURE_2D,0, 0, 0, 256, 256, GL_RGB, GL_FLOAT, c.tostring())
	c=ca.vector()
	glTexSubImage2D(GL_TEXTURE_2D,0, 0, 0, 256, 256, GL_LUMINANCE_ALPHA, GL_FLOAT, c.tostring())
#	c=ca.hueAngle()
#	glTexSubImage2D(GL_TEXTURE_2D,0, 0, 0, 256, 256, GL_LUMINANCE_ALPHA, GL_FLOAT, c.tostring())
	
	# -- Downsample 256->64: -
	drawSquare(64)
	glBindTexture(GL_TEXTURE_2D, tex64)
	glCopyTexSubImage2D(GL_TEXTURE_2D,0,0,0,0,0,64,64)
	
	# -- Downsample 64->16: -
	drawSquare(16)
	glBindTexture(GL_TEXTURE_2D, tex16)
	glCopyTexSubImage2D(GL_TEXTURE_2D,0,0,0,0,0,16,16)
	
	sBlock44.end()

	# ------------------------------------------------------
	
	sHue.use()
	glBindTexture(GL_TEXTURE_2D, tex256)
	drawSquare(512)
	glBindTexture(GL_TEXTURE_2D, tex64)
	glTranslatef(512.0,0.0,0.0)
	drawSquare(256)
	glBindTexture(GL_TEXTURE_2D, tex16)
	glTranslatef(0.0,256.0,0.0)
	drawSquare(256)
	sHue.end()
	
	glutSwapBuffers()
	

	

def init():
	
	# --Set up the simulation: -
	global ca
	
	ca = ca2d()
	ca.diff = 1
	ca.adv  = 1
	ca.D	= 0.2
	ca.A	= 0.02
	
	# -- Set up textures: -
	global tex256,tex64,tex16
	
	glEnable(GL_TEXTURE_2D)
	tex256  = createEmptyTextureSquare(256)
	tex64 	= createEmptyTextureSquare(64)
	tex16 	= createEmptyTextureSquare(16)#, GL_LINEAR)

	# -- Set up Shaders: -
	global sBlock44, sHue
	
	sBlock44 = glslBasic()
	sBlock44.load(0,caShaders.block44f)
	sHue = glslBasic()
	sHue.load(0,caShaders.huef)
	
	
	
# -------------------------------------------------------------------------------------
# -- Run the simulation: -
# -------------------------------------------------------------------------------------
if __name__ == '__main__':
	from psyco import *
		
	# -- Psycho!: -
	full()
	
	# -- Nasty GLUT code, something better than GLUT would be nice: -
	glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGBA)
	glutInitWindowSize(768, 512)
	glutCreateWindow("GL Experiments")
	glutDisplayFunc(display)
	glutIdleFunc(display)

	# -- Wrangle some extensions: -
	err = glewInit()
	if (err != GLEW_OK):
		print 'Error loading glew:', glewGetErrorString(err)
#		sys.exit()
	else:
		print 'GLEW Version:', glewGetString(GLEW_VERSION)

	# -- Set up the gl view: -
	glViewport(0,0,768, 512)
	glMatrixMode(GL_PROJECTION)
	glOrtho(0,768,0,512,0,1)
	glMatrixMode(GL_MODELVIEW)
	
	glClear(GL_COLOR_BUFFER_BIT);
	
	# -- Init the simulation: -
	init()
	
	# - Run: -
	glutMainLoop()