from caVis import *
from ca1d import *

from OpenGL.GL import *
from OpenGL.GLUT import *
from glew import *

from glslBasic import *
from glBasic import *

import caShaders


global ca, ca2, ts, ts2


def display():
	global ca, ca2, ts, ts2
	
	# -----------------------------------
	# -- Update simulation: -
	# -----------------------------------
	ca.update(1)
	o = ca.getAverage()
	
	ca2.update(1)
	o2 = ca2.getAverage()
	
	ts.update(o)
	ts2.update(o2)
	
	# -----------------------------------
	# -- Visualise: -
	# -----------------------------------	
	# -- ca1: -
	glLoadIdentity()
	ts.plot(4)
	
	# -- ca2: -
	glTranslatef(128.0,0.0,0.0)
	ts2.plot(4)
	
	# -- Difference: -
	glTranslatef(128.0,0.0,0.0)
	global sDiff
	
	sDiff.use()
	sDiff.setUniform1i(sDiff.getUniformIndex("tex1"),1)
	
	glActiveTexture(GL_TEXTURE1)
	glEnable(GL_TEXTURE_2D)
	glBindTexture(GL_TEXTURE_2D,ts2.tex)
	glActiveTexture(GL_TEXTURE0)
	
	ts.plot(4)
	
	glActiveTexture(GL_TEXTURE1)
	glDisable(GL_TEXTURE_2D)
	glActiveTexture(GL_TEXTURE0)
	sDiff.end()

	# -- Line plots: -
	glTranslatef(128.0,0.0,0.0)
	linePlot(o,[1.0,1.0,0.0,1.0],8.0,400.0)
	linePlot(o2,[0.0,1.0,0.0,1.0],8.0,400.0)
	
	glColor3f(1.0,1.0,1.0)
	
	glutSwapBuffers()

	
	
	
if __name__ == '__main__':
	from psyco import *
	
	full()
	# -- Nasty GLUT code, something better than GLUT would be nice: -
	glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGBA)
	glutInitWindowSize(640, 700)
	glutCreateWindow("GL Experiments")
	glutDisplayFunc(display)
	glutIdleFunc(display)

	# -- Wrangle some extensions: -
	err = glewInit()
	if (err != GLEW_OK):
		print 'Error loading glew:', glewGetErrorString(err)
#		sys.exit()
	else:
		print 'GLEW Version:', glewGetString(GLEW_VERSION)
	
	# -- Set up the gl view: -
	glViewport(0,0,640, 700)
	glMatrixMode(GL_PROJECTION)
	glOrtho(0,640,0,700,0,1)
	glMatrixMode(GL_MODELVIEW)
	
	glClear(GL_COLOR_BUFFER_BIT)
	
	# -- Set up shader: -
	global sDiff
	sDiff = glslBasic()
	sDiff.load(0,caShaders.lumDifferencef)

	# -- Set up the simulation: -
	global ca, ca2, ts, ts2
	
	# -- Paramater fudging, YaY \0/ : -
	ca = ca1dDiffuse()
	ca.diff  = 1
	ca.adv   = 1
	ca.rN	 = 20
	ca.rD	 = 0.99
	ca.lut   = ca.lutA
	ca.setInitial(0)
	
	ca2 = ca1dDiffuse()
	ca2.diff = 1
	ca2.adv  = 1
	ca2.rN	 = 20
	ca2.rD	 = 0.8
	ca2.lut  = ca2.lutB
	ca2.setInitial(0)
	
	ts = timeSeries1d(32,700)
	ts2= timeSeries1d(32,700)
	
	glutMainLoop()